﻿using System;
using System.Collections.Generic;
using System.Web.Mvc;
using HMS.Class.BLL;
using HMS.Class.Helper;
using HMS.Models;
using HMS.ViewModel;

namespace HMS.Controllers
{
     [LogOnAuthorize(Roles = "2,6")]
    public class PrivateBloodBankController : BaseController
    {
        #region Action Methods

        /// <summary>
        /// Add view action.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <returns>
        /// Returns add action result.
        /// </returns>
        public ActionResult Index()
        {
            ViewBag.Heading = "Blood Availability Status";
            var inventoryList = BloodInventoryBLL.GetBloodInventory();

            return Request.IsAjaxRequest() ? (ActionResult)PartialView("Index", inventoryList) : this.View(inventoryList);
        }

        /// <summary>
        /// Add view post action.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <param name="paymentVM">The model.</param>
        /// <returns>
        /// Returns add action result.
        /// </returns>
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Index(List<BloodInventoryModel> inventoryList)
        {
            try
            {
                ViewBag.Heading = "Blood Availability Status";

                if (ModelState.IsValid)
                {
                    BloodInventoryBLL.SaveBloodInventory(inventoryList);
                }
            }
            catch (System.Exception ex)
            {
                ViewBag.ErrorMsg = CommonLogic.GetExceptionMessage(ex);
            }

            return Request.IsAjaxRequest() ? (ActionResult)PartialView("Index", inventoryList) : this.View(inventoryList);
        }

        #endregion
    }
}
